@extends($activeTemplate . 'layouts.master')
@section('content')
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-md-12">
                <div class="text-end">
                    <a href="{{ route('ticket.open') }}" class="btn btn-sm btn--base btn--sm mb-2"> <i class="fas fa-plus"></i>
                        @lang('New Ticket')</a>
                </div>
                <table class="table table--collapse table--responsive--xl">
                    <thead>
                        <tr>
                            <th>@lang('Subject')</th>
                            <th>@lang('Status')</th>
                            <th>@lang('Priority')</th>
                            <th>@lang('Last Reply')</th>
                            <th>@lang('Action')</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($supports as $support)
                            <tr>
                                <td>
                                    <a href="{{ route('ticket.view', $support->ticket) }}" class="fw-bold text--base">
                                        [@lang('Ticket')#{{ $support->ticket }}] {{ __($support->subject) }} </a>
                                </td>
                                <td>
                                    @php echo $support->statusBadge; @endphp
                                </td>
                                <td>
                                    @if ($support->priority == Status::PRIORITY_LOW)
                                        <span class="badge badge--dark">@lang('Low')</span>
                                    @elseif($support->priority == Status::PRIORITY_MEDIUM)
                                        <span class="badge  badge--warning">@lang('Medium')</span>
                                    @elseif($support->priority == Status::PRIORITY_HIGH)
                                        <span class="badge badge--danger">@lang('High')</span>
                                    @endif
                                </td>
                                <td>{{ diffForHumans($support->last_reply) }} </td>

                                <td>
                                    <a href="{{ route('ticket.view', $support->ticket) }}" class="btn btn--base btn--sm">
                                        <i class="las la-desktop"></i>
                                    </a>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="100%" class="text-center">
                                    <div class="empty-message">
                                        <span class="empty-message-icon">
                                            <img src="{{ asset($activeTemplateTrue . 'images/no-data.gif') }}"
                                                 alt="">
                                        </span>
                                        <p class="empty-message-text">
                                            {{ __($emptyMessage) }}
                                        </p>
                                    </div>
                                </td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>


                {{ paginateLinks($supports) }}

            </div>
        </div>
    </div>
@endsection
