<?php

namespace App\Http\Controllers;

use App\Constants\Status;
use App\Lib\CurlRequest;
use App\Models\CronJob;
use App\Models\CronJobLog;
use App\Models\Order;
use App\Models\Provider;
use Carbon\Carbon;

class CronController extends Controller {
    public function cron() {
        $general            = gs();
        $general->last_cron = now();
        $general->save();

        $crons = CronJob::with('schedule');

        if (request()->alias) {
            $crons->where('alias', request()->alias);
        } else {
            $crons->where('next_run', '<', now())->where('is_running', Status::YES);
        }
        $crons = $crons->get();

        foreach ($crons as $cron) {
            $cronLog              = new CronJobLog();
            $cronLog->cron_job_id = $cron->id;
            $cronLog->start_at    = now();
            if ($cron->is_default) {

                $controller = new $cron->action[0];
                try {
                    $method = $cron->action[1];
                    $controller->$method();
                } catch (\Exception $e) {
                    $cronLog->error = $e->getMessage();
                }
            } else {
                try {
                    CurlRequest::curlContent($cron->url);
                } catch (\Exception $e) {
                    $cronLog->error = $e->getMessage();
                }
            }
            $cron->last_run = now();
            $cron->next_run = now()->addSeconds($cron->schedule->interval);
            $cron->save();

            $cronLog->end_at = $cron->last_run;

            $startTime         = Carbon::parse($cronLog->start_at);
            $endTime           = Carbon::parse($cronLog->end_at);
            $diffInSeconds     = $startTime->diffInSeconds($endTime);
            $cronLog->duration = $diffInSeconds;
            $cronLog->save();
        }
        if (request()->target == 'all') {
            $notify[] = ['success', 'Cron executed successfully'];
            return back()->withNotify($notify);
        }
        if (request()->alias) {
            $notify[] = ['success', keyToTitle(request()->alias) . ' executed successfully'];
            return back()->withNotify($notify);
        }
    }

    public function orderNotify() {
        $providers = Provider::where('send_email_for_order', '!=', 0)->get();

        foreach ($providers as $provider) {
            $order = Order::where('id', $provider->send_email_for_order)->where('status', Status::ORDER_PENDING)->first();
            if ($order) {
                notify($provider, 'ORDER_NOTIFY', [
                    'trx'            => $order->trx,
                    'order_number'   => $order->order_id,
                    'user_full_name' => $order->user->fullname,
                    'address'        => $order->user->address,
                    'total_price'    => showAmount($order->total, currencyFormat: false),
                    'payment_type'   => $order->payment_type == Status::ONLINE_PAYMENT ? trans('Online Payment') : trans('Cash On Delivery'),
                    'payment_status' => $order->payment_status == Status::PAID ? trans('Paid') : trans('Unpaid'),
                ]);

            }
            $provider->send_email_for_order = 0;
            $provider->save();
        }
    }
}
